/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.condition.AbstractQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProviderSerializer;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class SpecificWeaponConditionProvider
extends AbstractQuestConditionProvider<Condition> {
    private final Item[] validItems;
    private final Selector selector;
    private final String group;

    private SpecificWeaponConditionProvider(QuestConditionProviderType<SpecificWeaponConditionProvider> type, Selector selector, String group, Item[] items) {
        super(type);
        this.selector = selector;
        this.validItems = items;
        this.group = group;
    }

    public static SpecificWeaponConditionProvider fromNbt(QuestConditionProviderType<SpecificWeaponConditionProvider> type, CompoundNBT nbt) {
        Selector selector = Selector.values()[nbt.func_74762_e("selector")];
        ListNBT validItemList = nbt.func_150295_c("validItems", 8);
        Item[] items = new Item[validItemList.size()];
        int itemIndex = 0;
        for (INBT inbt : validItemList) {
            StringNBT stringNBT = (StringNBT)inbt;
            ResourceLocation itemId = new ResourceLocation(stringNBT.func_150285_a_());
            items[itemIndex++] = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        }
        String group = nbt.func_74779_i("group");
        return new SpecificWeaponConditionProvider(type, selector, group, items);
    }

    @Override
    public Condition makeConditionInstance() {
        return new Condition(this.selector.filterItems(this.validItems));
    }

    @Override
    public void saveInternalData(CompoundNBT nbt) {
        nbt.func_74768_a("selector", this.selector.ordinal());
        ListNBT list = new ListNBT();
        for (Item item : this.validItems) {
            list.add((Object)StringNBT.func_229705_a_((String)item.getRegistryName().toString()));
        }
        nbt.func_218657_a("validItems", (INBT)list);
        nbt.func_74778_a("group", this.group);
    }

    public class Condition
    implements IQuestCondition {
        private Item[] validItems;
        private ITextComponent[] descriptors;

        public Condition(Item[] validItems) {
            this.validItems = validItems;
            this.updateDescriptor();
        }

        @Override
        public boolean isValid(PlayerEntity player, IPropertyReader reader) {
            ItemStack stack = reader.getProperty(QuestProperties.USED_ITEM);
            return ModUtils.contains(stack.func_77973_b(), this.validItems);
        }

        @Override
        public ITextComponent getDescriptor(boolean shortDesc) {
            return this.descriptors[shortDesc ? 1 : 0];
        }

        @Override
        public IQuestConditionProvider<?> getProviderType() {
            return SpecificWeaponConditionProvider.this;
        }

        @Override
        public void saveData(CompoundNBT nbt) {
            ListNBT conditionItemList = new ListNBT();
            for (Item item : this.validItems) {
                conditionItemList.add((Object)StringNBT.func_229705_a_((String)item.getRegistryName().toString()));
            }
            nbt.func_218657_a("condition.items", (INBT)conditionItemList);
        }

        @Override
        public void loadData(CompoundNBT nbt) {
            ListNBT conditionItemList = nbt.func_150295_c("condition.items", 8);
            this.validItems = (Item[])conditionItemList.stream().map(inbt -> {
                ResourceLocation location = new ResourceLocation(inbt.func_150285_a_());
                return (Item)ForgeRegistries.ITEMS.getValue(location);
            }).toArray(Item[]::new);
            this.updateDescriptor();
        }

        private void updateDescriptor() {
            SpecificWeaponConditionProvider provider = SpecificWeaponConditionProvider.this;
            String text = provider.selector == Selector.ANY ? provider.group : this.validItems[0].func_200295_i(ItemStack.field_190927_a).getString();
            this.descriptors = AbstractQuestConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(provider.getLocalizationString(), new Object[]{text})});
        }
    }

    public static class Serializer
    implements IQuestConditionProviderSerializer<SpecificWeaponConditionProvider> {
        @Override
        public SpecificWeaponConditionProvider deserialize(QuestConditionProviderType<SpecificWeaponConditionProvider> conditionType, JsonElement data) {
            JsonObject object = JsonHelper.asJsonObject(data);
            String selectorId = JSONUtils.func_151219_a((JsonObject)object, (String)"selector", (String)"any").toUpperCase();
            Selector selector = Selector.ANY;
            try {
                selector = Selector.valueOf(selectorId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String group = JSONUtils.func_151219_a((JsonObject)object, (String)"group", (String)"");
            Item[] items = JsonHelper.deserializeInto(JSONUtils.func_151214_t((JsonObject)object, (String)"items"), Item[]::new, JsonHelper::resolveItem);
            return new SpecificWeaponConditionProvider(conditionType, selector, group, items);
        }
    }

    private static enum Selector {
        ONE(items -> {
            Random random = new Random();
            Item[] result = new Item[]{items[random.nextInt(((Item[])items).length)]};
            return result;
        }),
        ANY(items -> items);

        final Function<Item[], Item[]> filter;

        private Selector(Function<Item[], Item[]> filter) {
            this.filter = filter;
        }

        public Item[] filterItems(Item[] items) {
            return this.filter.apply(items);
        }
    }
}

